/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.misc;

public class MinMaxAvgLong {
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;
    private long total = 0L;

    public void add(long value) {
        this.total += value;
        this.min = Math.min(this.min, value);
        this.max = Math.max(this.max, value);
    }

    public void add(MinMaxAvgLong other) {
        this.total += other.total;
        this.min = Math.min(this.min, other.min);
        this.max = Math.max(this.max, other.max);
    }

    public void diff(long start, long end) {
        this.add(end - start);
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getTotal() {
        return this.total;
    }

    public long getAvg(long count) {
        return count == 0L ? 0L : this.total / count;
    }
}

